<?php
session_start();
include 'config/database.php';

if(!isset($_SESSION['user_id'])){
    header("Location: index.php");
    exit;
}

if($_SERVER['REQUEST_METHOD']=='POST'){
    $current = $_POST['current'];
    $new = $_POST['new'];

    $stmt = $conn->prepare("SELECT password FROM users WHERE id=?");
    $stmt->execute([$_SESSION['user_id']]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if($user && password_verify($current, $user['password'])){
        $hash = password_hash($new, PASSWORD_DEFAULT);
        $stmt = $conn->prepare("UPDATE users SET password=? WHERE id=?");
        $stmt->execute([$hash, $_SESSION['user_id']]);
        $msg = "Password changed successfully!";
    } else {
        $msg = "Current password is incorrect.";
    }
}
?>

<form method="post">
    Current Password: <input type="password" name="current" required><br>
    New Password: <input type="password" name="new" required><br>
    <button type="submit">Change Password</button>
</form>

<?php if(isset($msg)) echo $msg; ?>